/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.core.data;

import java.util.UUID;
import javax.annotation.Nullable;
import net.creeperhost.soulshardsrespawn.api.IBinding;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class Binding
implements IBinding,
INBTSerializable<CompoundTag> {
    @Nullable
    private ResourceLocation boundEntity;
    @Nullable
    private UUID owner;
    private int kills;

    public Binding(ResourceLocation boundEntity, UUID owner, int kills) {
        this.boundEntity = boundEntity;
        this.owner = owner;
        this.kills = kills;
    }

    public Binding(ResourceLocation boundEntity, int kills) {
        this(boundEntity, null, kills);
    }

    public Binding(CompoundTag bindingTag) {
        this.deserializeNBT(bindingTag);
    }

    @Override
    @Nullable
    public ResourceLocation getBoundEntity() {
        return this.boundEntity;
    }

    public Binding setBoundEntity(@Nullable ResourceLocation boundEntity) {
        this.boundEntity = boundEntity;
        return this;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public Binding setOwner(@Nullable UUID owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public int getKills() {
        return this.kills;
    }

    public Binding setKills(int kills) {
        this.kills = Math.min(Tier.maxKills, kills);
        return this;
    }

    @Override
    public Binding addKills(int kills) {
        this.kills = Math.min(Tier.maxKills, this.kills + kills);
        return this;
    }

    @Override
    public IShardTier getTier() {
        return Tier.TIERS.floorEntry(this.kills).getValue();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.boundEntity != null) {
            tag.m_128359_("bound", this.boundEntity.toString());
        }
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
        tag.m_128405_("kills", this.kills);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("bound")) {
            this.boundEntity = new ResourceLocation(nbt.m_128461_("bound"));
        }
        if (nbt.m_128403_("owner")) {
            this.owner = nbt.m_128342_("owner");
        }
        this.kills = nbt.m_128451_("kills");
    }

    @Nullable
    public static Binding fromNBT(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("binding")) {
            return null;
        }
        return new Binding(tag.m_128469_("binding"));
    }
}

